/************************************************************************\
	Derived from the source for the GNU uuencode and uudecode utilities.
	Copyright (C) 1994, 1995 Free Software Foundation, Inc.
\************************************************************************/


#include "objects.h"
#include "NewtonScript.h"


// Single character decode
#define	DEC(Char) (((Char) - ' ') & 0x3F)


static long _uudecodeB64 ( void * srcUnicodeP, void * destBinP );

extern "C" Ref UUDecodeB64 ( RefArg rcvr, RefArg srcUnicode, RefArg destBinObj )
{
/*
	if ( !IsString(srcUnicode) )
		ThrowBadTypeWithFrameData ( -48402, srcUnicode );	// expected a string

	if ( !IsBinary(destBinObj) )
		ThrowBadTypeWithFrameData ( -48408, destBinObj );	// expected a binary object
*/
	long	resultLength;

	WITH_LOCKED_BINARY ( srcUnicode, srcP )
	WITH_LOCKED_BINARY ( destBinObj, destP )

		resultLength = _uudecodeB64 ( srcP, destP );

	END_WITH_LOCKED_BINARY(srcUnicode)
	END_WITH_LOCKED_BINARY(destBinObj)

	return MakeInt ( resultLength );
}


long _uudecodeB64 ( void * srcUnicodeP, void * destBinP )
{
	short	* p       = (short *)srcUnicodeP;
	char	* resultP = (char *)destBinP;

	static const char b64_tab[256] =
	{
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*000-007*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*010-017*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*020-027*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*030-037*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*040-047*/
		0x7F, 0x7F, 0x7F, 0x3E, 0x7F, 0x7F, 0x7F, 0x3F, /*050-057*/
		0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, /*060-067*/
		0x3C, 0x3D, 0x7F, 0x7F, 0x7F, 0x40, 0x7F, 0x7F, /*070-077*/
		0x7F, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, /*100-107*/
		0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, /*110-117*/
		0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, /*120-127*/
		0x17, 0x18, 0x19, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*130-137*/
		0x7F, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, /*140-147*/
		0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, /*150-157*/
		0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, /*160-167*/
		0x31, 0x32, 0x33, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*170-177*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*200-207*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*210-217*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*220-227*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*230-237*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*240-247*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*250-257*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*260-267*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*270-277*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*300-307*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*310-317*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*320-327*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*330-337*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*340-347*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*350-357*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*360-367*/
		0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, /*370-377*/
	};

	while (1)
	{
		long last_data = 0;

		while ( *p == 13 )
			p++;

		if ( *p == 0 || *p == '=' )
			break;

		if ( p[0] == p[1] == p[2] == p[3] == '=' )
			break;

		/********************************************************************\
			The following implementation of the base64 decoding might look
			a bit clumsy but I only try to follow the POSIX standard:

				"All line breaks or other characters not found in the
				table [with base64 characters] shall be ignored by
				decoding software."
		\********************************************************************/

		while ( *p != '\n' )
		{
			char c1, c2, c3;

			while ( ( b64_tab[*p] & 0x40 ) != 0 )
				if ( *p == '\n' || *p++ == '=' )
					break;

			if ( *p == '\n' )		// This leaves the loop.
				continue;

			c1 = b64_tab[*p++];

			while (  (b64_tab[*p] & 0x40 ) != 0 )
				if ( *p == '\n' || *p++ == '=' )
				{
					return -1;		// illegal line
				}

			c2 = b64_tab[*p++];

			while ( b64_tab[*p] == 0x7F )
			if ( *p++ == '\n' )
			{
				return -1;		// illegal line
			}
			if (*p == '=')
			{
			//	putchar ( c1 << 2 | c2 >> 4 );
				*resultP++ = ( c1 << 2 | c2 >> 4 );
				last_data = 1;
				break;
			}
			c3 = b64_tab[*p++];

			while ( b64_tab[*p] == 0x7F )
				if ( *p++ == '\n' )
				{
					return -1;		// illegal line
				}

			*resultP++ = ( c1 << 2 | c2 >> 4 );
			*resultP++ = ( c2 << 4 | c3 >> 2 );

			if ( *p == '=' )
			{
				last_data = 1;
				break;
			}
			else
			{
				*resultP++ = ( c3 << 6 | b64_tab[*p++] );
			}
		}
	}

	long size = (long)resultP - (long)destBinP;

	return size;
}
